/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.BorderPaintLayerUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new GridLayout(2, 1));
        this.add(new JScrollPane(MainPanel.makeTable()));
        this.add(new JLayer<JScrollPane>(new JScrollPane(MainPanel.makeTable()), new BorderPaintLayerUI()));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static TableModel makeModel() {
        Object[] columnNames = new String[]{"A1", "B1", "A2", "B2"};
        Object[][] data = new Object[][]{{1, 33, 5, 7}, {2, 35, 6, 11}, {3, 34, 7, 12}, {4, 35, 8, 9}};
        return new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
    }

    private static JTable makeTable() {
        return new JTable(MainPanel.makeModel()){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFillsViewportHeight(true);
                this.setShowVerticalLines(false);
                this.setShowHorizontalLines(false);
                this.setIntercellSpacing(new Dimension());
                this.setAutoCreateRowSorter(true);
                this.getTableHeader().setReorderingAllowed(false);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    ((JComponent)c).setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3));
                }
                return c;
            }
        };
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST VerticalRulesTable");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

