/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;

class BorderPaintLayerUI
extends LayerUI<JScrollPane> {
    BorderPaintLayerUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Object view;
        super.paint(g, c);
        if (c instanceof JLayer && (view = ((JLayer)c).getView()) instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)view;
            JViewport viewport = scroll.getViewport();
            JTable table = (JTable)viewport.getView();
            this.paintVerticalRules(g, table, scroll);
        }
    }

    private void paintVerticalRules(Graphics g, JTable table, JComponent parent) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(UIManager.getColor("Table.gridColor"));
        int columnCount = table.getModel().getColumnCount();
        if (columnCount % 2 == 0) {
            int center = columnCount / 2 - 1;
            double x1 = table.getCellRect(0, center, false).getMaxX();
            Rectangle r = SwingUtilities.calculateInnerArea(parent, null);
            g2.draw(new Line2D.Double(x1, r.getY(), x1, r.getHeight()));
            double x2 = x1 + 2.0;
            g2.draw(new Line2D.Double(x2, r.getY(), x2, r.getHeight()));
            g2.dispose();
        }
    }
}

