/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.ColorEditor;
import example.ColorRenderer;
import example.DateEditor;
import example.UndoableCellEdit;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class PropertyTable
extends JTable {
    private static final int TARGET_COLUMN = 1;
    private Class<?> editingClass;
    private final UndoManager undoManager = new UndoManager();

    protected PropertyTable(TableModel model) {
        super(model);
        this.initUndoActions();
    }

    private void initUndoActions() {
        String undo = "undo";
        String redo = "redo";
        ActionMap am = this.getActionMap();
        am.put(undo, new UndoAction());
        am.put(redo, new RedoAction());
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke("ctrl Z"), undo);
        im.put(KeyStroke.getKeyStroke("ctrl shift Z"), redo);
        im.put(KeyStroke.getKeyStroke("ctrl Y"), redo);
    }

    private Class<?> getClassAt(int row, int column) {
        int mc = this.convertColumnIndexToModel(column);
        int mr = this.convertRowIndexToModel(row);
        TableModel m = this.getModel();
        return mc == 1 ? m.getValueAt(mr, mc).getClass() : null;
    }

    @Override
    public void updateUI() {
        this.setSelectionForeground(new ColorUIResource(Color.RED));
        this.setSelectionBackground(new ColorUIResource(Color.RED));
        super.updateUI();
        this.setDefaultRenderer(Color.class, new ColorRenderer());
        this.setDefaultEditor(Color.class, new ColorEditor());
        this.setDefaultEditor(Date.class, new DateEditor());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Class<?> clz = this.getClassAt(row, column);
        return Objects.nonNull(clz) ? this.getDefaultRenderer(clz) : super.getCellRenderer(row, column);
    }

    @Override
    public void setValueAt(Object newValue, int row, int column) {
        int mc;
        int mr;
        Object oldValue;
        if (this.isEditing() && !Objects.equals(oldValue = this.getValueAt(mr = this.convertRowIndexToModel(row), mc = this.convertColumnIndexToModel(column)), newValue)) {
            TableModel model = this.getModel();
            this.undoManager.addEdit(new UndoableCellEdit(model, mr, mc, oldValue, newValue));
        }
        super.setValueAt(newValue, row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        this.editingClass = this.getClassAt(row, column);
        return Objects.nonNull(this.editingClass) ? this.getDefaultEditor(this.editingClass) : super.getCellEditor(row, column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.convertColumnIndexToModel(column) == 1 ? this.editingClass : super.getColumnClass(column);
    }

    private class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super("redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PropertyTable.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)e.getSource());
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super("undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PropertyTable.this.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)e.getSource());
            }
        }
    }
}

