/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.PropertyTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new BorderLayout());
        PropertyTable table = new PropertyTable(MainPanel.makeModel());
        this.add(new JScrollPane(table));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static TableModel makeModel() {
        Object[] columnNames = new String[]{"Type", "Value"};
        Object[][] data = new Object[][]{{"String", "text"}, {"Date", new Date()}, {"Integer", 12}, {"Double", 3.45}, {"Boolean", true}, {"Color", Color.RED}};
        return new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST UndoableEditTable");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

