/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

class DateEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JSpinner spinner = new JSpinner(new SpinnerDateModel());

    protected DateEditor() {
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.spinner, "yyyy/MM/dd");
        this.spinner.setEditor(editor);
        this.setArrowButtonEnabled(false);
        editor.getTextField().setHorizontalAlignment(2);
        editor.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DateEditor.this.setArrowButtonEnabled(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                DateEditor.this.setArrowButtonEnabled(true);
                EventQueue.invokeLater(() -> {
                    JTextField field = (JTextField)e.getComponent();
                    field.setCaretPosition(8);
                    field.setSelectionStart(8);
                    field.setSelectionEnd(10);
                });
            }
        });
        this.spinner.setBorder(BorderFactory.createEmptyBorder());
    }

    protected final void setArrowButtonEnabled(boolean flag) {
        for (Component c : this.spinner.getComponents()) {
            if (!(c instanceof JButton)) continue;
            c.setEnabled(flag);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.spinner.setValue(value);
        return this.spinner;
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        boolean stopEditing = true;
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException ex) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
            stopEditing = false;
        }
        return stopEditing && super.stopCellEditing();
    }
}

