/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final String EDIT = "edit";
    private final JButton button = new JButton();
    private final JColorChooser colorChooser;
    private final JDialog dialog;
    private Color currentColor;

    protected ColorEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setContentAreaFilled(false);
        this.button.setFocusPainted(false);
        this.button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.button.setOpaque(false);
        this.button.setHorizontalAlignment(2);
        this.button.setHorizontalTextPosition(4);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            this.button.setIcon(new ColorIcon(this.currentColor));
            this.colorChooser.setColor(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentColor = (Color)value;
        this.button.setIcon(new ColorIcon(this.currentColor));
        int r = this.currentColor.getRed();
        int g = this.currentColor.getGreen();
        int b = this.currentColor.getBlue();
        this.button.setText(String.format("(%d, %d, %d)", r, g, b));
        return this.button;
    }
}

