/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.AutoRepeatHandler;
import example.RoundFormattedTextField;
import example.RoundPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

class TimePickerSplitFieldDemo {
    TimePickerSplitFieldDemo() {
    }

    public JPanel createPickerPanel() {
        JFormattedTextField fieldHour = TimePickerSplitFieldDemo.makeNumberField(12, 1, 0, 23);
        JFormattedTextField fieldMinute = TimePickerSplitFieldDemo.makeNumberField(30, 1, 0, 59);
        JPanel pnlUp = new JPanel(new GridLayout(1, 2));
        pnlUp.add(TimePickerSplitFieldDemo.makeCenteredBox(TimePickerSplitFieldDemo.makeArrowButton(fieldHour, 1, 0, 23)));
        pnlUp.add(TimePickerSplitFieldDemo.makeCenteredBox(TimePickerSplitFieldDemo.makeArrowButton(fieldMinute, 1, 0, 59)));
        JPanel pnlDown = new JPanel(new GridLayout(1, 2));
        pnlDown.add(TimePickerSplitFieldDemo.makeCenteredBox(TimePickerSplitFieldDemo.makeArrowButton(fieldHour, -1, 0, 23)));
        pnlDown.add(TimePickerSplitFieldDemo.makeCenteredBox(TimePickerSplitFieldDemo.makeArrowButton(fieldMinute, -1, 0, 59)));
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setOpaque(false);
        panel.add((Component)pnlUp, "North");
        panel.add(TimePickerSplitFieldDemo.makeTimeFieldPanel(fieldHour, fieldMinute));
        panel.add((Component)pnlDown, "South");
        return panel;
    }

    public static JButton makeArrowButton(JTextField field, int delta, int min, int max) {
        String txt = delta > 0 ? "\u23f6" : "\u23f7";
        JButton button = new JButton(txt);
        button.setFocusable(false);
        AutoRepeatHandler handler = new AutoRepeatHandler(field, delta, min, max);
        button.addActionListener(handler);
        button.addMouseListener(handler);
        return button;
    }

    private static Box makeCenteredBox(JButton button) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(button);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private static JPanel makeTimeFieldPanel(JTextField hour, JTextField minute) {
        RoundPanel panel = new RoundPanel(8);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.setOpaque(false);
        panel.setBackground(new Color(0xDEDEDE));
        panel.add(Box.createHorizontalGlue());
        panel.add(hour);
        JLabel colon = new JLabel(":");
        colon.setFont(colon.getFont().deriveFont(42.0f));
        colon.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        panel.add(colon);
        panel.add(minute);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public static JFormattedTextField makeNumberField(int value, int step, int min, int max) {
        RoundFormattedTextField field = new RoundFormattedTextField(value, step, min, max);
        try {
            MaskFormatter mask = new MaskFormatter("##");
            mask.setPlaceholderCharacter('0');
            field.setFormatterFactory(new DefaultFormatterFactory(mask));
        }
        catch (ParseException ex) {
            UIManager.getLookAndFeel().provideErrorFeedback(field);
        }
        field.setFont(field.getFont().deriveFont(42.0f));
        field.setHorizontalAlignment(0);
        field.setColumns(2);
        return field;
    }
}

