/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

class TimePickerSingleField {
    private JFormattedTextField timeField;
    private LocalTime currentTime = LocalTime.of(12, 30);
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");

    TimePickerSingleField() {
    }

    public Component createMainPanel() {
        try {
            MaskFormatter mask = new MaskFormatter("##:##");
            mask.setPlaceholderCharacter('0');
            this.timeField = new JFormattedTextField(mask);
        }
        catch (ParseException ex) {
            this.timeField = new JFormattedTextField();
        }
        this.timeField.setFont(new Font("Monospaced", 1, 42));
        this.timeField.setHorizontalAlignment(0);
        this.timeField.setEditable(false);
        this.timeField.setFocusable(true);
        this.updateDisplay();
        this.timeField.addMouseWheelListener(e -> {
            boolean isUp = e.getWheelRotation() < 0;
            boolean isHourSide = this.timeField.viewToModel(e.getPoint()) <= 2;
            this.adjustTime(isHourSide, isUp);
        });
        return this.timeField;
    }

    private void adjustTime(boolean isHour, boolean isUp) {
        this.currentTime = isHour ? (isUp ? this.currentTime.plusHours(1L) : this.currentTime.minusHours(1L)) : (isUp ? this.currentTime.plusMinutes(1L) : this.currentTime.minusMinutes(1L));
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.timeField.setText(this.currentTime.format(this.timeFormatter));
    }
}

