/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.AutoRepeatHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

class RoundFormattedTextField
extends JFormattedTextField {
    private transient FocusListener listener;

    protected RoundFormattedTextField(int value, int step, int min, int max) {
        super((Object)String.format("%02d", value));
        this.addMouseWheelListener(e -> {
            int delta = e.getWheelRotation() < 0 ? 1 : -1;
            Component c = e.getComponent();
            if (c instanceof JTextComponent) {
                AutoRepeatHandler.adjust((JTextComponent)c, delta * step, min, max);
            }
        });
    }

    @Override
    public void updateUI() {
        this.removeFocusListener(this.listener);
        super.updateUI();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setBackground(new Color(0xCECECE));
        this.setSelectionColor(new Color(0, true));
        this.setSelectedTextColor(this.getForeground());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setCaret(new DefaultCaret(){

            @Override
            public boolean isVisible() {
                return false;
            }
        });
        this.setCursor(new Cursor(0));
        this.listener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Component c = e.getComponent();
                c.setForeground(UIManager.getColor("TextField.foreground"));
            }

            @Override
            public void focusLost(FocusEvent e) {
                e.getComponent().setForeground(Color.DARK_GRAY);
            }
        };
        this.addFocusListener(this.listener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.hasFocus()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getBackground());
            g2.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 8.0, 8.0));
            g2.setColor(this.getBackground().darker());
            g2.draw(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 8.0, 8.0));
            g2.dispose();
        }
        super.paintComponent(g);
    }
}

