/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;

class AutoRepeatHandler
extends MouseAdapter
implements ActionListener {
    private final Timer autoRepeatTimer;
    private final JTextComponent view;
    private final int delta;
    private final int min;
    private final int max;
    private JButton arrowButton;

    protected AutoRepeatHandler(JTextComponent view, int delta, int min, int max) {
        this.view = view;
        this.delta = delta;
        this.min = min;
        this.max = max;
        this.autoRepeatTimer = new Timer(60, this);
        this.autoRepeatTimer.setInitialDelay(300);
    }

    public static void adjust(JTextComponent field, int delta, int min, int max) {
        field.requestFocusInWindow();
        int range = max - min + 1;
        int value = Integer.parseInt(field.getText());
        value = (value - min + delta) % range;
        if (value < 0) {
            value += range;
        }
        field.setText(String.format("%02d", value += min));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof Timer) {
            boolean released;
            boolean bl = released = Objects.nonNull(this.arrowButton) && !this.arrowButton.getModel().isPressed();
            if (released && this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
            }
        } else if (o instanceof JButton) {
            this.arrowButton = (JButton)o;
        }
        AutoRepeatHandler.adjust(this.view, this.delta, this.min, this.max);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
            this.autoRepeatTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.autoRepeatTimer.stop();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.autoRepeatTimer.isRunning()) {
            this.autoRepeatTimer.stop();
        }
    }
}

