/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

class TagInputPanel
extends JPanel {
    private final List<String> tags = new ArrayList<String>();
    private final JTextField textField = new JTextField(15);
    private final JPanel tagContainer = new JPanel(new FlowLayout(0)){

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBackground(UIManager.getColor("TextField.background"));
        }
    };

    protected TagInputPanel() {
        super(new BorderLayout());
        this.textField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textField.addActionListener(e -> {
            String text = this.textField.getText().trim();
            if (!text.isEmpty() && !this.tags.contains(text)) {
                this.addTag(text);
                this.textField.setText("");
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && TagInputPanel.this.textField.getText().isEmpty()) {
                    TagInputPanel.this.removeLastTag();
                    e.consume();
                }
            }
        });
        this.tagContainer.add(this.textField);
        JScrollPane scroll = new JScrollPane(this.tagContainer){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setHorizontalScrollBarPolicy(31);
                this.setVerticalScrollBarPolicy(21);
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setViewportBorder(BorderFactory.createEmptyBorder());
            }
        };
        this.add(scroll);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setBackground(UIManager.getColor("TextField.background"));
    }

    @Override
    public final Component add(Component comp) {
        return super.add(comp);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Container getTagContainer() {
        return this.tagContainer;
    }

    private void addTag(String text) {
        JPanel tag = new JPanel(new BorderLayout(5, 0));
        tag.setName(text);
        tag.setBackground(new Color(230, 245, 255));
        tag.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Table.selectionBackground")), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        this.tags.add(text);
        tag.add(new JLabel(text));
        tag.add((Component)this.makeCloseButton(tag), "East");
        this.tagContainer.add((Component)tag, this.tagContainer.getComponentCount() - 1);
        this.resizeAndRepaint();
    }

    private JButton makeCloseButton(JPanel tag) {
        JButton closeBtn = new JButton("\u00d7"){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setContentAreaFilled(false);
                this.setFocusPainted(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEmptyBorder());
            }
        };
        closeBtn.addActionListener(e -> {
            this.tags.remove(tag.getName());
            this.tagContainer.remove(tag);
            this.resizeAndRepaint();
        });
        closeBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setForeground(Color.RED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.getComponent().setForeground(UIManager.getColor("Button.foreground"));
            }
        });
        return closeBtn;
    }

    private void removeLastTag() {
        boolean moreThanOne;
        int count = this.tagContainer.getComponentCount();
        boolean bl = moreThanOne = count > 1;
        if (moreThanOne) {
            this.tags.remove(this.tags.size() - 1);
            this.tagContainer.remove(count - 2);
            this.resizeAndRepaint();
        }
    }

    private void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }
}

