/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Component;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

final class TabbedPanePopupMenu
extends JPopupMenu {
    private final JMenuItem closePage;
    private final JMenuItem closeAll;
    private final JMenuItem closeAllButActive;

    TabbedPanePopupMenu() {
        AtomicInteger counter = new AtomicInteger();
        this.add("New tab").addActionListener(e -> {
            JTabbedPane tabs = (JTabbedPane)this.getInvoker();
            TabbedPanePopupMenu.addTab(counter, tabs);
            tabs.setSelectedIndex(tabs.getTabCount() - 1);
        });
        this.add("New tab Opens in Background").addActionListener(e -> {
            JTabbedPane tabs = (JTabbedPane)this.getInvoker();
            TabbedPanePopupMenu.addTab(counter, tabs);
        });
        this.addSeparator();
        this.closePage = this.add("Close");
        this.closePage.addActionListener(e -> {
            JTabbedPane tabs = (JTabbedPane)this.getInvoker();
            tabs.remove(tabs.getSelectedIndex());
        });
        this.addSeparator();
        this.closeAll = this.add("Close all");
        this.closeAll.addActionListener(e -> {
            JTabbedPane tabs = (JTabbedPane)this.getInvoker();
            tabs.removeAll();
        });
        this.closeAllButActive = this.add("Close all bat active");
        this.closeAllButActive.addActionListener(e -> {
            JTabbedPane tabs = (JTabbedPane)this.getInvoker();
            int idx = tabs.getSelectedIndex();
            String title = tabs.getTitleAt(idx);
            Component cmp = tabs.getComponentAt(idx);
            tabs.removeAll();
            tabs.addTab(title, cmp);
        });
    }

    private static void addTab(AtomicInteger counter, JTabbedPane tabs) {
        int iv = counter.getAndIncrement();
        tabs.addTab("Title: " + iv, new JLabel("Tab: " + iv));
    }

    @Override
    public void show(Component c, int x, int y) {
        if (c instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)c;
            this.closePage.setEnabled(tabs.indexAtLocation(x, y) >= 0);
            this.closeAll.setEnabled(tabs.getTabCount() > 0);
            this.closeAllButActive.setEnabled(tabs.getTabCount() > 0);
            super.show(c, x, y);
        }
    }
}

