/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.plaf.LayerUI;

class TabHighlightLayerUI
extends LayerUI<JTabbedPane> {
    private static final int MAX = 32;
    private final Rectangle rect = new Rectangle();
    private final Timer animator = new Timer(10, null);
    private transient ActionListener listener;
    private int alpha;

    TabHighlightLayerUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(32768L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(0L);
        }
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (c instanceof JLayer) {
            Graphics2D g2 = (Graphics2D)g.create();
            float a = (float)this.alpha / 100.0f;
            g2.setComposite(AlphaComposite.getInstance(3, a));
            g2.setPaint(Color.RED);
            g2.fill(this.rect);
            g2.dispose();
        }
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent e, JLayer<? extends JTabbedPane> l) {
        super.processHierarchyEvent(e, l);
        Container parent = e.getChangedParent();
        JTabbedPane tabs = l.getView();
        long flags = e.getChangeFlags();
        if (Objects.equals(parent, tabs) && flags == 1L) {
            EventQueue.invokeLater(() -> this.startAnime(l, e.getComponent()));
        }
    }

    private void startAnime(JLayer<? extends JTabbedPane> l, Component c) {
        JTabbedPane tabs = l.getView();
        int idx = tabs.indexOfComponent(c);
        Rectangle tabRect = tabs.getBoundsAt(idx);
        if (tabs.getBounds().contains(tabRect)) {
            this.rect.setBounds(tabRect);
        } else {
            JButton b = TabHighlightLayerUI.getScrollForwardButton(tabs);
            if (b != null) {
                this.rect.setBounds(b.getBounds());
            }
        }
        this.animator.start();
        this.animator.removeActionListener(this.listener);
        this.listener = ae -> {
            if (this.alpha < 32) {
                ++this.alpha;
            } else {
                this.alpha = 0;
                this.animator.stop();
            }
            l.paintImmediately(this.rect);
        };
        this.animator.addActionListener(this.listener);
        this.animator.start();
    }

    private static JButton getScrollForwardButton(JTabbedPane tabs) {
        JComponent button1 = null;
        JComponent button2 = null;
        for (Component c : tabs.getComponents()) {
            if (!(c instanceof JButton)) continue;
            if (Objects.isNull(button1)) {
                button1 = (JButton)c;
                continue;
            }
            if (!Objects.isNull(button2)) continue;
            button2 = (JButton)c;
        }
        int x1 = Objects.nonNull(button1) ? button1.getX() : -1;
        int x2 = Objects.nonNull(button2) ? button2.getX() : -1;
        return x1 > x2 ? button1 : button2;
    }
}

