/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicProgressBarUI;

class ScrollIndicatorUI
extends BasicProgressBarUI {
    ScrollIndicatorUI() {
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        Rectangle r = SwingUtilities.calculateInnerArea(this.progressBar, null);
        BoundedRangeModel m = this.progressBar.getModel();
        if (!r.isEmpty()) {
            int range = m.getMaximum() - m.getMinimum();
            int extent = (int)Math.floor((float)(r.width * m.getExtent()) / (float)range);
            int amountFull = this.getAmountFull(b, r.width, r.height) + extent;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(UIManager.getColor("ProgressBar.foreground"));
            if (this.progressBar.getOrientation() == 0) {
                g2.fillRect(r.x, r.y, amountFull, r.height);
            } else {
                g2.fillRect(r.x, r.y + r.height - amountFull, r.width, amountFull);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g2, r.x, r.y, r.width, r.height, amountFull, b);
            }
            g2.dispose();
        }
    }
}

