/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.ScrollIndicator;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private static final String LF = "\n";

    private MainPanel() {
        super(new BorderLayout());
        StringBuilder buf = new StringBuilder();
        IntStream.range(0, 100).forEach(i -> buf.append(i).append(LF));
        JScrollPane scroll = new JScrollPane(new JTextArea(buf.toString()));
        BoundedRangeModel model = scroll.getVerticalScrollBar().getModel();
        ScrollIndicator progress = new ScrollIndicator(model);
        scroll.setColumnHeaderView(progress);
        this.add(scroll);
        this.setPreferredSize(new Dimension(320, 240));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST ScrollIndicator");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

