/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSliderUI;

class TriangleUI
extends BasicSliderUI {
    private final boolean isUpward;

    protected TriangleUI(JSlider b, boolean isUpward) {
        super(b);
        this.isUpward = isUpward;
    }

    @Override
    public void paintTrack(Graphics g) {
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    protected void calculateTrackBuffer() {
        if (this.slider.getOrientation() == 0) {
            this.trackBuffer = 20;
        } else {
            super.calculateTrackBuffer();
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        int[] nArray;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(40, 44, 52));
        Rectangle r = SwingUtilities.calculateInnerArea(this.slider, null);
        int h = 8;
        int x = this.thumbRect.x;
        int y = this.isUpward ? r.y : r.y + r.height - h;
        int[] xps = new int[]{x, x + this.thumbRect.width / 2, x + this.thumbRect.width};
        if (this.isUpward) {
            int[] nArray2 = new int[3];
            nArray2[0] = y + h;
            nArray2[1] = y;
            nArray = nArray2;
            nArray2[2] = y + h;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = y;
            nArray3[1] = y + h;
            nArray = nArray3;
            nArray3[2] = y;
        }
        int[] yps = nArray;
        g2.fillPolygon(xps, yps, xps.length);
        g2.dispose();
    }
}

