/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.RangeBar;
import example.TriangleUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

class RangeSliderPanel
extends JPanel {
    private final JSlider lowerSlider;
    private final JSlider upperSlider;

    protected RangeSliderPanel(int min, int max, int lowInit, int highInit) {
        super(new BorderLayout(0, 0));
        this.upperSlider = RangeSliderPanel.createSlider(min, max, highInit, false);
        this.lowerSlider = RangeSliderPanel.createSlider(min, max, lowInit, true);
        ChangeListener cl = e -> {
            if (this.lowerSlider.getValue() > this.upperSlider.getValue()) {
                if (Objects.equals(e.getSource(), this.lowerSlider)) {
                    this.lowerSlider.setValue(this.upperSlider.getValue());
                } else {
                    this.upperSlider.setValue(this.lowerSlider.getValue());
                }
            }
            this.repaint();
        };
        this.lowerSlider.addChangeListener(cl);
        this.upperSlider.addChangeListener(cl);
        this.add((Component)this.upperSlider, "North");
        this.add(new RangeBar(this.lowerSlider, this.upperSlider));
        this.add((Component)this.lowerSlider, "South");
    }

    @Override
    public final Component add(Component comp) {
        return super.add(comp);
    }

    @Override
    public final void add(Component comp, Object constraints) {
        super.add(comp, constraints);
    }

    private static JSlider createSlider(int min, int max, int val, final boolean isUp) {
        return new JSlider(min, max, val){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setUI(new TriangleUI(this, isUp));
                this.setOpaque(false);
                this.setPaintTicks(false);
                this.setPaintLabels(false);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 10;
                return d;
            }
        };
    }
}

