/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class RangeBar
extends JLabel {
    public static final int BAR_HEIGHT = 24;
    public static final int PAD = 20;
    private static final Color MAJOR_TICK_COLOR = new Color(180, 180, 185);
    private static final Color MINOR_TICK_COLOR = new Color(210, 210, 215);
    private static final Color TRACK_BGC = new Color(230, 230, 235);
    private static final Color RANGE_COLOR = new Color(0, 180, 255, 120);
    private final JSlider low;
    private final JSlider up;
    private final Point dragStartPt = new Point(0, 0);
    private int slLow;
    private int slUp;
    private transient MouseAdapter dragListener;

    protected RangeBar(JSlider low, JSlider up) {
        this.low = low;
        this.up = up;
    }

    @Override
    public void updateUI() {
        this.removeMouseListener(this.dragListener);
        this.removeMouseMotionListener(this.dragListener);
        super.updateUI();
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.dragListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RangeBar.this.dragStartPt.setLocation(e.getPoint());
                RangeBar.this.slLow = RangeBar.this.low.getValue();
                RangeBar.this.slUp = RangeBar.this.up.getValue();
                RangeBar.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RangeBar.this.dragStartPt.setLocation(-100, -100);
                RangeBar.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (((RangeBar)RangeBar.this).dragStartPt.x >= 0) {
                    RangeBar.this.updateRange(e.getX() - ((RangeBar)RangeBar.this).dragStartPt.x);
                }
                RangeBar.this.repaint();
            }
        };
        this.addMouseListener(this.dragListener);
        this.addMouseMotionListener(this.dragListener);
    }

    private void updateRange(int diff) {
        double trackW = (double)this.low.getWidth() - 40.0;
        int range = this.low.getMaximum() - this.low.getMinimum();
        int delta = (int)Math.round((double)(diff * range) / trackW);
        int ln = this.slLow + delta;
        int un = this.slUp + delta;
        if (ln >= this.low.getMinimum() && un <= this.low.getMaximum()) {
            this.low.setValue(ln);
            this.up.setValue(un);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 24);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth() - 40 - 1;
        int cy = this.getHeight() / 2;
        int barH = 23;
        RangeBar.paintTrack(g2, w, cy, barH);
        RangeBar.paintTicks(g2, w, cy, barH);
        int lx = RangeBar.getPositionX(this.low);
        int ux = RangeBar.getPositionX(this.up);
        RangeBar.paintRangeBar(g2, cy, barH, lx, ux);
        this.paintNumber(g2, cy, lx, ux);
        g2.dispose();
    }

    private static void paintTrack(Graphics2D g2, int w, int cy, int barH) {
        g2.setColor(TRACK_BGC);
        RoundRectangle2D.Float track = new RoundRectangle2D.Float(20.0f, (float)cy - (float)barH / 2.0f, w, barH, 4.0f, 4.0f);
        g2.fill(track);
        g2.setColor(TRACK_BGC.darker());
        g2.draw(track);
    }

    private static void paintTicks(Graphics2D g2, int w, int cy, int barH) {
        for (int i = 0; i <= 100; i += 2) {
            int tx = 20 + i * w / 100;
            if (i % 10 == 0) {
                g2.setColor(MAJOR_TICK_COLOR);
                g2.drawLine(tx, cy - barH / 2, tx, cy + barH / 2);
                continue;
            }
            g2.setColor(MINOR_TICK_COLOR);
            g2.drawLine(tx, cy - 4, tx, cy + 4);
        }
    }

    private static void paintRangeBar(Graphics2D g2, int cy, int barH, int lx, int ux) {
        g2.setPaint(RANGE_COLOR);
        RoundRectangle2D.Float bar = new RoundRectangle2D.Float(lx, (float)cy - (float)barH / 2.0f, ux - lx, barH, 4.0f, 4.0f);
        g2.fill(bar);
        g2.setColor(RANGE_COLOR.darker());
        g2.draw(bar);
    }

    private void paintNumber(Graphics2D g2, int cy, int lx, int ux) {
        g2.setColor(UIManager.getColor("Button.foreground"));
        String txtLow = String.valueOf(this.low.getValue());
        String txtUp = String.valueOf(this.up.getValue());
        FontMetrics fm = g2.getFontMetrics();
        int gap = 2;
        int ty = cy + fm.getAscent() / 2 - 1;
        g2.drawString(txtLow, lx - fm.stringWidth(txtLow) - gap, ty);
        g2.drawString(txtUp, ux + gap, ty);
    }

    private static int getPositionX(JSlider slider) {
        int iv = slider.getValue() - slider.getMinimum();
        int range = slider.getMaximum() - slider.getMinimum();
        double v = (double)iv / (double)range;
        Rectangle r = SwingUtilities.calculateInnerArea(slider, null);
        return 20 + (int)(v * ((double)r.width - 40.0));
    }
}

