/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SelectionIndicatorMenuBar
extends JMenuBar {
    private static final Color SELECTION_COLOR = new Color(43775);
    private static final int SZ = 3;
    private final Rectangle rect = new Rectangle();
    private transient ChangeListener listener;

    SelectionIndicatorMenuBar() {
    }

    @Override
    public void updateUI() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        manager.removeChangeListener(this.listener);
        super.updateUI();
        Border inside = BorderFactory.createEmptyBorder(4, 0, 0, 0);
        Border outside = UIManager.getBorder("MenuBar.border");
        CompoundBorder border = BorderFactory.createCompoundBorder(outside, inside);
        this.setBorder(border);
        this.listener = this::updateTopLevelMenuBorder;
        manager.addChangeListener(this.listener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.rect.isEmpty()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(SELECTION_COLOR);
            g2.fillRect(this.rect.x, this.rect.y - 3, this.rect.width, 3);
            g2.dispose();
        }
    }

    private void updateTopLevelMenuBorder(ChangeEvent e) {
        Object o = e.getSource();
        this.rect.setSize(0, 0);
        MenuElement[] p = ((MenuSelectionManager)o).getSelectedPath();
        if (p != null && p.length > 1 && Objects.equals(this, p[0].getComponent())) {
            this.updateMenuBorder(p[1].getComponent());
        }
        this.repaint();
    }

    private void updateMenuBorder(Component c) {
        JMenu menu;
        ButtonModel m;
        if (c instanceof JMenu && ((JMenu)c).isTopLevelMenu() && ((m = (menu = (JMenu)c).getModel()).isArmed() || m.isPressed() || m.isSelected())) {
            this.rect.setBounds(menu.getBounds());
        }
    }
}

