/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeListener;

class SelectionHighlightMenuBar
extends JMenuBar {
    private static final Color ALPHA_ZERO = new Color(0, true);
    private static final Color SELECTION_COLOR = new Color(43775);
    private static final int SZ = 3;
    private transient ChangeListener listener;

    SelectionHighlightMenuBar() {
    }

    @Override
    public void updateUI() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        manager.removeChangeListener(this.listener);
        super.updateUI();
        this.listener = e -> this.updateTopLevelMenuBorder();
        manager.addChangeListener(this.listener);
        EventQueue.invokeLater(this::updateTopLevelMenuBorder);
    }

    private void updateTopLevelMenuBorder() {
        for (MenuElement me : this.getSubElements()) {
            this.updateMenuBorder(me.getComponent());
        }
    }

    private void updateMenuBorder(Component c) {
        JMenu menu;
        if (c instanceof JMenu && (menu = (JMenu)c).isTopLevelMenu() && menu.getParent().equals(this)) {
            ButtonModel model = menu.getModel();
            boolean b = model.isArmed() || model.isPressed() || model.isSelected();
            Color color = b ? SELECTION_COLOR : ALPHA_ZERO;
            Border inside = UIManager.getBorder("Menu.border");
            MatteBorder outside = BorderFactory.createMatteBorder(0, 0, 3, 0, color);
            menu.setBorder(BorderFactory.createCompoundBorder(outside, inside));
        }
    }
}

