/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.plaf.LayerUI;

class MenuHighlightLayerUI
extends LayerUI<JMenuBar> {
    private static final Color SELECTION_COLOR = new Color(43775);
    private static final int SZ = 3;
    private final Rectangle rect = new Rectangle();

    MenuHighlightLayerUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(48L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(0L);
        }
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (c instanceof JLayer && !this.rect.isEmpty()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(SELECTION_COLOR);
            g2.fillRect(this.rect.x, this.rect.y + this.rect.height - 3, this.rect.width, 3);
            g2.dispose();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends JMenuBar> l) {
        super.processMouseEvent(e, l);
        if (e.getID() == 505) {
            this.rect.setSize(0, 0);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends JMenuBar> l) {
        super.processMouseMotionEvent(e, l);
        Component c = e.getComponent();
        if (c instanceof JMenu) {
            this.rect.setBounds(c.getBounds());
        } else {
            this.rect.setSize(0, 0);
        }
    }
}

