/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class ArrowButtonHandler
extends AbstractAction
implements MouseListener {
    private final Timer repeatTimer;
    private final boolean isNext;
    private final JSpinner spinner;
    private JButton arrowButton;

    protected ArrowButtonHandler(JSpinner spinner, String name, boolean isNext) {
        super(name);
        this.spinner = spinner;
        this.isNext = isNext;
        this.repeatTimer = new Timer(60, this);
        this.repeatTimer.setInitialDelay(300);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object value;
        Object src = e.getSource();
        if (src instanceof Timer) {
            if (ArrowButtonHandler.isPressed(this.arrowButton) && this.repeatTimer.isRunning()) {
                this.repeatTimer.stop();
                this.setArrowButton(null);
            }
        } else if (src instanceof JButton) {
            this.setArrowButton((JButton)src);
        }
        Object object = value = this.isNext ? this.spinner.getNextValue() : this.spinner.getPreviousValue();
        if (value != null) {
            this.spinner.setValue(value);
        }
    }

    private void setArrowButton(JButton button) {
        this.arrowButton = button;
    }

    private static boolean isPressed(JButton button) {
        return button != null && !button.getModel().isPressed();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
            this.repeatTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.repeatTimer.stop();
        this.setArrowButton(null);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.repeatTimer.isRunning()) {
            this.repeatTimer.stop();
        }
    }
}

