/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.ArrowButtonHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicArrowButton;

class ArrowButtonEnlargeListener
extends MouseAdapter {
    private final JPopupMenu popup = new JPopupMenu();

    ArrowButtonEnlargeListener() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Container c = SwingUtilities.getAncestorOfClass(JSpinner.class, e.getComponent());
        if (SwingUtilities.isLeftMouseButton(e) && c instanceof JSpinner) {
            JSpinner spinner = (JSpinner)c;
            JButton bigNextBtn = ArrowButtonEnlargeListener.makeArrowButton(spinner, true);
            JButton bigPrevBtn = ArrowButtonEnlargeListener.makeArrowButton(spinner, false);
            this.popup.setLayout(new GridLayout(2, 1));
            this.popup.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.popup.setFocusable(false);
            this.popup.removeAll();
            this.popup.add(bigNextBtn);
            this.popup.add(bigPrevBtn);
            this.popup.pack();
            JComponent editor = spinner.getEditor();
            Rectangle r = SwingUtilities.calculateInnerArea(editor, null);
            int px = (int)r.getMaxX();
            int py = (int)r.getCenterY() - bigNextBtn.getPreferredSize().height;
            this.popup.show(editor, px, py);
        }
    }

    private static JButton makeArrowButton(JSpinner spinner, boolean isNext) {
        int direction = isNext ? 1 : 5;
        BasicArrowButton arrowButton = new BasicArrowButton(direction){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width *= 4;
                d.height *= 2;
                return d;
            }
        };
        String name = isNext ? "increment" : "decrement";
        ArrowButtonHandler handler = new ArrowButtonHandler(spinner, name, isNext);
        arrowButton.addActionListener(handler);
        arrowButton.addMouseListener(handler);
        return arrowButton;
    }
}

