/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.WeekHeaderRenderer;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.Optional;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class MonthTable
extends JTable {
    MonthTable() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JTableHeader header = this.getTableHeader();
        header.setResizingAllowed(false);
        header.setReorderingAllowed(false);
        this.updateWeekHeaderRenderer();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                JTable tbl = this.getTable();
                int rowCount = tbl.getModel().getRowCount() + 1;
                Class<JViewport> clz = JViewport.class;
                d.height = Optional.ofNullable(SwingUtilities.getAncestorOfClass(clz, tbl)).filter(clz::isInstance).map(clz::cast).map(JViewport::getExtentSize).map(dim -> dim.height / rowCount).orElse(24);
                return d;
            }
        };
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        EventQueue.invokeLater(this::updateWeekHeaderRenderer);
    }

    private void updateWeekHeaderRenderer() {
        TableColumnModel cm = this.getColumnModel();
        WeekHeaderRenderer r = new WeekHeaderRenderer();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setHeaderRenderer(r);
        }
        this.getTableHeader().repaint();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Class<JViewport> clz = JViewport.class;
        Optional.ofNullable(SwingUtilities.getAncestorOfClass(clz, this)).filter(clz::isInstance).map(clz::cast).ifPresent(this::updateRowsHeight);
    }

    private void updateRowsHeight(JViewport viewport) {
        int height = viewport.getExtentSize().height;
        int rowCount = this.getModel().getRowCount() + 1;
        int defaultRowHeight = height / rowCount;
        int remainder = height % rowCount;
        for (int i = 0; i < rowCount; ++i) {
            int a = Math.min(1, Math.max(0, remainder--));
            this.setRowHeight(i, defaultRowHeight + a);
        }
    }
}

