/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarUtils;
import example.CalendarViewTableModel;
import example.DiagonallySplitCellLayerUI;
import example.MonthTable;
import example.WeekHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableCellRenderer;

public final class MainPanel
extends JPanel {
    private final Map<DayOfWeek, Color> holidayColorMap = new EnumMap<DayOfWeek, Color>(DayOfWeek.class);
    private final JLabel monthLabel = new JLabel("", 0);
    private final JTable monthTable = new MonthTable();
    private LocalDate currentLocalDate;

    private MainPanel() {
        super(new BorderLayout());
        this.monthTable.setDefaultRenderer(LocalDate.class, new CalendarTableRenderer());
        this.monthTable.setSelectionMode(0);
        this.monthTable.setCellSelectionEnabled(true);
        this.monthTable.setFillsViewportHeight(true);
        this.holidayColorMap.put(DayOfWeek.SUNDAY, WeekHeaderRenderer.SUNDAY_BGC);
        this.holidayColorMap.put(DayOfWeek.SATURDAY, WeekHeaderRenderer.SATURDAY_BGC);
        this.updateMonthView(LocalDate.of(2025, 11, 11));
        JButton prev = new JButton("<");
        prev.addActionListener(e -> this.updateMonthView(this.getCurrentLocalDate().minusMonths(1L)));
        JButton next = new JButton(">");
        next.addActionListener(e -> this.updateMonthView(this.getCurrentLocalDate().plusMonths(1L)));
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.monthLabel);
        p.add((Component)prev, "West");
        p.add((Component)next, "East");
        this.add((Component)p, "North");
        JScrollPane scroll = new JScrollPane(this.monthTable){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setVerticalScrollBarPolicy(21);
            }
        };
        this.add(scroll);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(320, 240));
    }

    public LocalDate getCurrentLocalDate() {
        return this.currentLocalDate;
    }

    public void updateMonthView(LocalDate localDate) {
        this.currentLocalDate = localDate;
        Locale locale = Locale.getDefault();
        DateTimeFormatter fmt = CalendarUtils.getLocalizedYearMonthFormatter(locale);
        String txt = localDate.format(fmt.withLocale(locale));
        this.monthLabel.setText(CalendarUtils.getLocalizedYearMonthText(txt));
        this.monthTable.setModel(new CalendarViewTableModel(localDate));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST HeaderColumnBackground");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private final class CalendarTableRenderer
    extends DefaultTableCellRenderer {
        private final JPanel panel = new JPanel(new BorderLayout());

        private CalendarTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JLayer<JPanel> c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            if (value instanceof LocalDate && c instanceof JLabel) {
                boolean isLastRow;
                LocalDate d = (LocalDate)value;
                JLabel l = (JLabel)((Object)c);
                l.setText(Integer.toString(d.getDayOfMonth()));
                l.setVerticalAlignment(1);
                l.setHorizontalAlignment(2);
                this.panel.setBackground(l.getBackground());
                this.updateWeekColor(d, table, c, selected);
                LocalDate nextWeekDay = d.plusDays(7L);
                boolean bl = isLastRow = row == table.getModel().getRowCount() - 1;
                if (isLastRow && this.isDiagonallySplitCell(nextWeekDay)) {
                    JLabel sub = new JLabel(Integer.toString(nextWeekDay.getDayOfMonth()));
                    sub.setFont(l.getFont());
                    sub.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    sub.setOpaque(false);
                    sub.setVerticalAlignment(3);
                    sub.setHorizontalAlignment(4);
                    this.updateWeekColor(d, table, sub, selected);
                    this.panel.removeAll();
                    this.panel.add((Component)sub, "South");
                    this.panel.add((Component)c, "North");
                    this.panel.setBorder(l.getBorder());
                    l.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    c = new JLayer<JPanel>(this.panel, new DiagonallySplitCellLayerUI());
                }
            }
            return c;
        }

        private boolean isDiagonallySplitCell(LocalDate nextWeekDay) {
            return YearMonth.from(nextWeekDay).equals(YearMonth.from(MainPanel.this.getCurrentLocalDate()));
        }

        private void updateWeekColor(LocalDate d, JTable table, Component c, boolean selected) {
            if (selected) {
                c.setForeground(table.getSelectionForeground());
            } else {
                Color fgc = (Color)MainPanel.this.holidayColorMap.get(d.getDayOfWeek());
                if (fgc != null) {
                    c.setForeground(fgc);
                } else if (YearMonth.from(d).equals(YearMonth.from(MainPanel.this.getCurrentLocalDate()))) {
                    c.setForeground(table.getForeground());
                } else {
                    c.setForeground(Color.GRAY);
                }
            }
        }
    }
}

