/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.GroupBorderList;
import example.GroupList;
import example.LookAndFeelUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new GridLayout(1, 0));
        String title0 = "Box + Multiple JList + JSeparator";
        this.add(MainPanel.makeTitledPanel(title0, MainPanel.makeListBox()));
        String title1 = "JSeparator + ListModel";
        this.add(MainPanel.makeTitledPanel(title1, new GroupList<Object>(MainPanel.makeModel1())));
        String title2 = "CellRenderer + MatteBorder";
        this.add(MainPanel.makeTitledPanel(title2, new GroupBorderList<TreeNode>(MainPanel.makeModel2())));
        JMenuBar mb = new JMenuBar();
        mb.add(LookAndFeelUtils.createLookAndFeelMenu());
        EventQueue.invokeLater(() -> this.getRootPane().setJMenuBar(mb));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static Component makeTitledPanel(String title, Component c) {
        JScrollPane scroll = new JScrollPane(c);
        scroll.setHorizontalScrollBarPolicy(31);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(title));
        p.add(scroll);
        return p;
    }

    private static Container makeListBox() {
        Box box = Box.createVerticalBox();
        JTree tree = new JTree();
        TreeModel model = tree.getModel();
        TreeNode root = (TreeNode)model.getRoot();
        Collections.list(root.children()).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).forEach(node -> {
            if (!node.isLeaf()) {
                Enumeration<? extends TreeNode> children = node.children();
                box.add(MainPanel.makeList(Collections.list(children).toArray()));
                box.add(new JSeparator());
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.setBackground(UIManager.getColor("List.background"));
        p.add((Component)box, "North");
        return p;
    }

    private static JList<Object> makeList(Object ... ary) {
        JList<Object> c = new JList<Object>(ary){

            @Override
            public void updateUI() {
                this.setCellRenderer(null);
                super.updateUI();
                ListCellRenderer r = this.getCellRenderer();
                this.setCellRenderer((l, v, index, isSelected, cellHasFocus) -> {
                    boolean selected = isSelected && l.isFocusOwner();
                    return r.getListCellRendererComponent(l, v, index, selected, cellHasFocus);
                });
            }
        };
        int height = c.getPreferredSize().height;
        c.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
        return c;
    }

    private static ListModel<Object> makeModel1() {
        JTree tree = new JTree();
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        Collections.list(root.children()).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).forEach(node -> {
            if (!node.isLeaf()) {
                Collections.list(node.children()).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).forEach(model::addElement);
                model.addElement(new JSeparator());
            }
        });
        int last = model.getSize() - 1;
        if (model.getElementAt(last) instanceof JSeparator) {
            model.remove(last);
        }
        return model;
    }

    private static ListModel<TreeNode> makeModel2() {
        JTree tree = new JTree();
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        DefaultListModel<TreeNode> model = new DefaultListModel<TreeNode>();
        Collections.list(root.children()).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).forEach(node -> {
            if (!node.isLeaf()) {
                Collections.list(node.children()).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).forEach(model::addElement);
            }
        });
        return model;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST GroupingListItems");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

