/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

class GroupList<E>
extends JList<E> {
    protected GroupList(ListModel<E> model) {
        super(model);
        GroupList.initActionMpa(this);
    }

    @Override
    public void updateUI() {
        this.setCellRenderer(null);
        super.updateUI();
        ListCellRenderer r = this.getCellRenderer();
        this.setCellRenderer((l, v, index, isSelected, cellHasFocus) -> v instanceof JSeparator ? (JSeparator)v : r.getListCellRendererComponent(l, v, index, isSelected, cellHasFocus));
    }

    private static <E> void initActionMpa(JList<E> list) {
        ActionMap am = list.getActionMap();
        String selectPrevKey = "selectPreviousRow";
        final Action prev = am.get(selectPrevKey);
        am.put(selectPrevKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                prev.actionPerformed(e);
                JList l = (JList)e.getSource();
                int index = l.getSelectedIndex();
                Object o = l.getModel().getElementAt(index);
                if (o instanceof JSeparator) {
                    prev.actionPerformed(e);
                }
            }
        });
        String selectNextKey = "selectNextRow";
        final Action next = am.get(selectNextKey);
        am.put(selectNextKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                next.actionPerformed(e);
                JList l = (JList)e.getSource();
                int index = l.getSelectedIndex();
                Object o = l.getModel().getElementAt(index);
                if (o instanceof JSeparator) {
                    next.actionPerformed(e);
                }
            }
        });
        InputMap im = list.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(38, 0), selectPrevKey);
        im.put(KeyStroke.getKeyStroke(224, 0), selectPrevKey);
        im.put(KeyStroke.getKeyStroke(40, 0), selectNextKey);
        im.put(KeyStroke.getKeyStroke(225, 0), selectNextKey);
    }
}

