/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;

class GroupBorderList<E extends TreeNode>
extends JList<E> {
    protected GroupBorderList(ListModel<E> model) {
        super(model);
    }

    @Override
    public void updateUI() {
        this.setCellRenderer(null);
        super.updateUI();
        ListCellRenderer r = this.getCellRenderer();
        this.setCellRenderer((l, v, index, isSelected, cellHasFocus) -> {
            Component c = r.getListCellRendererComponent(l, v, index, isSelected, cellHasFocus);
            if (c instanceof JComponent) {
                Border outside = GroupBorderList.getOutsideBorder(l, v, index);
                String key = isSelected ? "List.focusCellHighlightBorder" : "List.noFocusBorder";
                Border inside = UIManager.getBorder(key);
                ((JComponent)c).setBorder(BorderFactory.createCompoundBorder(outside, inside));
            }
            return c;
        });
    }

    private static Border getOutsideBorder(JList<?> l, TreeNode v, int index) {
        int next = index + 1;
        int max = l.getModel().getSize();
        Object n = next < max ? (Object)l.getModel().getElementAt(next) : null;
        return Optional.ofNullable(n).filter(TreeNode.class::isInstance).map(TreeNode.class::cast).map(TreeNode::getParent).filter(p -> !Objects.equals(p, v.getParent())).map(p -> BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY)).orElseGet(() -> BorderFactory.createMatteBorder(0, 0, 1, 0, l.getBackground()));
    }
}

