/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.GradientFadeOutSeparator;
import example.LookAndFeelUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new BorderLayout());
        this.add((Component)MainPanel.makeVerticalBox(), "North");
        this.add((Component)MainPanel.makeHorizontalBox(), "East");
        JMenuBar mb = new JMenuBar();
        mb.add(LookAndFeelUtils.createLookAndFeelMenu());
        EventQueue.invokeLater(() -> this.getRootPane().setJMenuBar(mb));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static Box makeVerticalBox() {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        box.add(Box.createVerticalStrut(10));
        box.add(new JSeparator(0));
        box.add(Box.createVerticalStrut(10));
        box.add(new JLabel("\u2191 Default JSeparator"));
        box.add(Box.createVerticalStrut(20));
        box.add(new GradientFadeOutSeparator(0));
        box.add(Box.createVerticalStrut(10));
        box.add(new JLabel("\u2191 GradientFadeOutSeparator"));
        box.add(Box.createVerticalStrut(10));
        return box;
    }

    private static Box makeHorizontalBox() {
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        box.add(Box.createHorizontalStrut(10));
        box.add(new JSeparator(1));
        box.add(Box.createHorizontalStrut(10));
        box.add(new GradientFadeOutSeparator(1));
        box.add(Box.createHorizontalStrut(10));
        return box;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST GradientFadeOutSeparator");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

