/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Toolkit;
import java.awt.Window;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

final class LookAndFeelUtils {
    private static String lookAndFeel = UIManager.getLookAndFeel().getClass().getName();

    private LookAndFeelUtils() {
    }

    public static JMenu createLookAndFeelMenu() {
        JMenu menu = new JMenu("LookAndFeel");
        ButtonGroup buttonGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            AbstractButton b = LookAndFeelUtils.makeButton(info);
            LookAndFeelUtils.initLookAndFeelAction(info, b);
            menu.add(b);
            buttonGroup.add(b);
        }
        return menu;
    }

    private static AbstractButton makeButton(UIManager.LookAndFeelInfo info) {
        boolean selected = info.getClassName().equals(lookAndFeel);
        return new JRadioButtonMenuItem(info.getName(), selected);
    }

    public static void initLookAndFeelAction(UIManager.LookAndFeelInfo info, AbstractButton b) {
        String cmd = info.getClassName();
        b.setText(info.getName());
        b.setActionCommand(cmd);
        b.setHideActionText(true);
        b.addActionListener(e -> LookAndFeelUtils.setLookAndFeel(cmd));
    }

    private static void setLookAndFeel(String newLookAndFeel) {
        String oldLookAndFeel = lookAndFeel;
        if (!oldLookAndFeel.equals(newLookAndFeel)) {
            try {
                UIManager.setLookAndFeel(newLookAndFeel);
                lookAndFeel = newLookAndFeel;
            }
            catch (UnsupportedLookAndFeelException ignored) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                Logger.getGlobal().severe(ex::getMessage);
                return;
            }
            LookAndFeelUtils.updateLookAndFeel();
        }
    }

    private static void updateLookAndFeel() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }
}

