/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

class GradientSeparatorUI
extends BasicSeparatorUI {
    private Color backgroundColor;
    private Color shadowColor;
    private Color highlightColor;

    GradientSeparatorUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new GradientSeparatorUI();
    }

    private void updateColors(Component c) {
        Color bgc = c.getBackground();
        Color c1 = UIManager.getColor("Panel.background");
        this.backgroundColor = c1 instanceof ColorUIResource ? c1 : bgc;
        Color c2 = UIManager.getColor("Separator.shadow");
        this.shadowColor = c2 instanceof ColorUIResource ? c2 : bgc.darker();
        Color c3 = UIManager.getColor("Separator.highlight");
        this.highlightColor = c3 instanceof ColorUIResource ? c3 : bgc.brighter();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateColors(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c instanceof JSeparator) {
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle r = SwingUtilities.calculateInnerArea(c, null);
            float centerX = (float)r.getCenterX();
            float centerY = (float)r.getCenterY();
            Point2D.Float center = new Point2D.Float(centerX, centerY);
            float radius = Math.max(r.width, r.height);
            float[] dist = new float[]{0.1f, 0.6f};
            Color[] colors1 = new Color[]{this.shadowColor, this.backgroundColor};
            RadialGradientPaint p1 = new RadialGradientPaint(center, radius, dist, colors1);
            Color[] colors2 = new Color[]{this.highlightColor, this.backgroundColor};
            RadialGradientPaint p2 = new RadialGradientPaint(center, radius, dist, colors2);
            if (((JSeparator)c).getOrientation() == 0) {
                g2.setPaint(p1);
                g2.fillRect(0, 0, r.width, 1);
                g2.setPaint(p2);
                g2.fillRect(0, 1, r.width, 1);
            } else {
                g2.setPaint(p1);
                g2.fillRect(0, 0, 1, r.height);
                g2.setPaint(p2);
                g2.fillRect(1, 0, 1, r.height);
            }
            g2.dispose();
        }
    }
}

