/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class Resizer
extends MouseAdapter {
    private final Point startPt = new Point();
    private final Dimension startSize = new Dimension();
    private final JPopupMenu popup;

    protected Resizer(JPopupMenu popup) {
        this.popup = popup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startPt.setLocation(e.getLocationOnScreen());
        this.startSize.setSize(this.popup.getSize());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int dx = e.getLocationOnScreen().x - this.startPt.x;
        int dy = e.getLocationOnScreen().y - this.startPt.y;
        int minWidth = this.popup.getInvoker().getWidth();
        int width = Math.max(minWidth, this.startSize.width + dx);
        int height = Math.max(100, this.startSize.height + dy);
        Dimension newSize = new Dimension(width, height);
        this.popup.setPreferredSize(newSize);
        Window w = SwingUtilities.getWindowAncestor(this.popup);
        if (w != null && w.getType() == Window.Type.POPUP) {
            w.setSize(newSize.width, newSize.height);
        } else {
            this.popup.pack();
        }
    }
}

