/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.ExpandArrowIcon;
import example.OverlayLayoutPanel;
import example.Resizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class ExpandableTextField
extends OverlayLayoutPanel {
    private final JTextField textField = new JTextField(20);
    private final JTextArea textArea = new JTextArea();
    private final JPopupMenu popup = new JPopupMenu(){
        private transient PopupMenuListener listener;

        @Override
        public void updateUI() {
            this.removePopupMenuListener(this.listener);
            super.updateUI();
            JPanel footer = new JPanel(new FlowLayout(2, 0, 0));
            footer.add(ExpandableTextField.makeResizeLabel(this));
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(ExpandableTextField.this.textArea));
            this.add((Component)footer, "South");
            this.listener = new ExpandPopupMenuListener();
            this.addPopupMenuListener(this.listener);
        }
    };

    protected ExpandableTextField() {
        ExpandArrowIcon icon = new ExpandArrowIcon();
        JButton expandBtn = ExpandableTextField.makeExpandButton(icon);
        expandBtn.addActionListener(e -> this.popup.show(this.textField, 0, 0));
        this.add(expandBtn);
        this.textField.setMargin(new Insets(0, 0, 0, icon.getIconWidth()));
        this.textField.setAlignmentX(1.0f);
        this.textField.setAlignmentY(0.5f);
        this.add(this.textField);
    }

    @Override
    public final Component add(Component comp) {
        return super.add(comp);
    }

    private static JLabel makeResizeLabel(JPopupMenu popup) {
        JLabel resizeLabel = new JLabel("\u25e2");
        resizeLabel.setCursor(Cursor.getPredefinedCursor(5));
        Resizer resizer = new Resizer(popup);
        resizeLabel.addMouseListener(resizer);
        resizeLabel.addMouseMotionListener(resizer);
        return resizeLabel;
    }

    private static JButton makeExpandButton(ExpandArrowIcon icon) {
        JButton expandBtn = new JButton(icon);
        expandBtn.setMargin(new Insets(0, 0, 0, 0));
        expandBtn.setContentAreaFilled(false);
        expandBtn.setFocusable(false);
        expandBtn.setBorderPainted(false);
        expandBtn.setAlignmentX(1.0f);
        expandBtn.setAlignmentY(0.5f);
        return expandBtn;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    private final class ExpandPopupMenuListener
    implements PopupMenuListener {
        private ExpandPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ExpandableTextField.this.textArea.setText(ExpandableTextField.this.textField.getText().replace(" ", "\n") + "\n");
            ExpandableTextField.this.textArea.requestFocusInWindow();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ExpandableTextField.this.textField.setText(ExpandableTextField.this.textArea.getText().replace("\n", " ").trim());
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

