/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

class ExpandArrowIcon
implements Icon {
    private static final String ARROW = "\u21f5";

    ExpandArrowIcon() {
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(c.getForeground());
        int cx = x + this.getIconWidth() / 2;
        int cy = y + this.getIconHeight() / 2;
        g2.rotate(Math.toRadians(45.0), cx, cy);
        g2.setFont(c.getFont().deriveFont(14.0f));
        FontMetrics fm = g2.getFontMetrics();
        int tx = cx - fm.stringWidth(ARROW) / 2;
        int ty = cy + (fm.getAscent() - fm.getDescent()) / 2;
        g2.drawString(ARROW, tx, ty);
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return 18;
    }

    @Override
    public int getIconHeight() {
        return 18;
    }
}

