/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;

class MenuDragLayerUI
extends LayerUI<JMenuBar> {
    private static final int DRAG_THRESHOLD = 8;
    private JMenu draggingMenu;
    private JWindow ghostWindow;
    private JLabel ghostLabel;
    private Point startPt;
    private boolean isDragging;
    private int targetIndex = -1;
    private int dividerX = -1;

    MenuDragLayerUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(48L);
        }
        this.ghostWindow = new JWindow();
        this.ghostWindow.setOpacity(0.7f);
        this.ghostLabel = new JLabel();
        this.ghostLabel.setOpaque(false);
        this.ghostLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.ghostLabel.setCursor(Cursor.getPredefinedCursor(13));
        this.ghostWindow.add(this.ghostLabel);
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(0L);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends JMenuBar> l) {
        JMenuBar bar = l.getView();
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), bar);
        if (e.getID() == 501) {
            Component c = bar.getComponentAt(p);
            if (c instanceof JMenu) {
                this.draggingMenu = (JMenu)c;
                this.startPt = p;
            }
        } else if (e.getID() == 502) {
            if (this.isDragging && this.draggingMenu != null) {
                this.finalizeDrop(bar);
            }
            this.resetDragState(l);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends JMenuBar> l) {
        if (this.draggingMenu != null) {
            JMenuBar bar = l.getView();
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), bar);
            if (!this.isDragging && this.startPt != null && this.startPt.distance(p) > 8.0) {
                this.initiateDrag(e);
            }
            if (this.isDragging) {
                this.updateDragFeedback(e, bar, p);
                l.repaint();
                e.consume();
            }
        }
    }

    private void initiateDrag(MouseEvent e) {
        this.isDragging = true;
        MenuSelectionManager.defaultManager().clearSelectedPath();
        this.draggingMenu.setEnabled(false);
        this.ghostLabel.setText(this.draggingMenu.getText());
        this.ghostLabel.setFont(this.draggingMenu.getFont());
        this.ghostWindow.pack();
        this.updateGhostLocation(e);
        this.ghostWindow.setVisible(true);
    }

    private void updateDragFeedback(MouseEvent e, JMenuBar bar, Point p) {
        this.updateGhostLocation(e);
        Component[] menus = bar.getComponents();
        this.targetIndex = 0;
        this.dividerX = menus.length > 0 ? menus[0].getX() : 0;
        for (int i = 0; i < menus.length; ++i) {
            Component m = menus[i];
            if (Objects.equals(m, this.draggingMenu)) continue;
            int midX = m.getX() + m.getWidth() / 2;
            if (p.x < midX) {
                this.targetIndex = i;
                this.dividerX = m.getX();
                break;
            }
            this.targetIndex = i + 1;
            this.dividerX = m.getX() + m.getWidth();
        }
    }

    private void finalizeDrop(JMenuBar bar) {
        int currentIdx = -1;
        for (int i = 0; i < bar.getComponentCount(); ++i) {
            if (!Objects.equals(bar.getComponent(i), this.draggingMenu)) continue;
            currentIdx = i;
            break;
        }
        int finalIdx = this.targetIndex;
        if (currentIdx != -1 && currentIdx < this.targetIndex) {
            --finalIdx;
        }
        bar.add((Component)this.draggingMenu, Math.max(0, finalIdx));
        this.draggingMenu.setEnabled(true);
    }

    private void resetDragState(JLayer<? extends JMenuBar> l) {
        if (this.draggingMenu != null) {
            this.draggingMenu.setEnabled(true);
        }
        this.ghostWindow.setVisible(false);
        this.draggingMenu = null;
        this.isDragging = false;
        this.targetIndex = -1;
        this.dividerX = -1;
        l.getView().revalidate();
        l.repaint();
    }

    private void updateGhostLocation(MouseEvent e) {
        Point screenPt = e.getLocationOnScreen();
        this.ghostWindow.setLocation(screenPt.x + 10, screenPt.y + 10);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.isDragging && this.dividerX != -1) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(UIManager.getColor("List.dropLineColor"));
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(this.dividerX, 0, this.dividerX, c.getHeight());
            g2.dispose();
        }
    }
}

