/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.MenuDragLayerUI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new BorderLayout());
        String[] titles;
        JMenuBar menuBar = new JMenuBar();
        for (String title : titles = new String[]{"File", "Edit", "Code", "Analyze", "Refactor", "Help"}) {
            menuBar.add(MainPanel.makeMenu(title));
        }
        JLayer<JMenuBar> menuLayer = new JLayer<JMenuBar>(menuBar, new MenuDragLayerUI());
        this.add(menuLayer, "North");
        this.add(new JScrollPane(new JTextArea()));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static JMenu makeMenu(String title) {
        JMenu menu = new JMenu(title);
        menu.add("MenuItem 1");
        menu.add("MenuItem 2");
        menu.add("MenuItem 3");
        return menu;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST DraggableMenu");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

