/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.GeomUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.LayerUI;

class TranslucentCellSelectionLayerUI
extends LayerUI<JScrollPane> {
    private static final float WIDTH = 2.0f;
    private static final float MITER = 5.0f;
    private static final float[] DASH = new float[]{4.0f, 2.0f};
    private static final Stroke BORDER_STROKE1 = new BasicStroke(2.0f, 0, 0, 5.0f, DASH, 0.0f);
    private static final Stroke BORDER_STROKE2 = new BasicStroke(2.0f, 0, 0, 5.0f, DASH, 2.0f);
    private static Stroke borderStroke = BORDER_STROKE1;
    private JTable table;
    private boolean flg;
    private final Timer animator = new Timer(480, e -> {
        if (this.table != null && !this.table.isEditing()) {
            borderStroke = this.flg ? BORDER_STROKE1 : BORDER_STROKE2;
            TranslucentCellSelectionLayerUI.repaintSelectedArea(this.table);
            this.flg = !this.flg;
        }
    });

    TranslucentCellSelectionLayerUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(4L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(0L);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void processFocusEvent(FocusEvent e, JLayer<? extends JScrollPane> l) {
        this.table = TranslucentCellSelectionLayerUI.getTable(l);
        if (e.getID() == 1004) {
            this.animator.start();
        } else {
            this.animator.stop();
        }
        super.processFocusEvent(e, l);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        JTable table = TranslucentCellSelectionLayerUI.getTable(c);
        int cc = table.getSelectedColumnCount();
        int rc = table.getSelectedRowCount();
        if (cc != 0 && rc != 0 && !table.isEditing()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area area = new Area();
            TranslucentCellSelectionLayerUI.getSelectedArea(table).forEach(r -> {
                Rectangle rect = SwingUtilities.convertRectangle(table, r, c);
                area.add(new Area(rect));
            });
            Dimension ics = table.getIntercellSpacing();
            Color v = table.getSelectionBackground();
            Color sbc = new Color(v.getRed(), v.getGreen(), v.getBlue(), 50);
            for (Area a : GeomUtils.singularization(area)) {
                Rectangle r2 = a.getBounds();
                r2.width -= ics.width - 1;
                r2.height -= ics.height - 1;
                g2.setPaint(sbc);
                g2.fill(r2);
                g2.setPaint(v);
                g2.setStroke(borderStroke);
                g2.draw(r2);
            }
            g2.dispose();
        }
    }

    private static List<Rectangle> getSelectedArea(JTable tbl) {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        for (int row : tbl.getSelectedRows()) {
            for (int col : tbl.getSelectedColumns()) {
                if (!tbl.isCellSelected(row, col)) continue;
                list.add(tbl.getCellRect(row, col, true));
            }
        }
        return list;
    }

    private static JTable getTable(Component c) {
        Object c1;
        JTable table = null;
        if (c instanceof JLayer && (c1 = ((JLayer)c).getView()) instanceof JScrollPane) {
            table = (JTable)((JScrollPane)c1).getViewport().getView();
        }
        return table;
    }

    private static void repaintSelectedArea(JTable tbl) {
        int cc = tbl.getSelectedColumnCount();
        int rc = tbl.getSelectedRowCount();
        if (cc != 0 && rc != 0) {
            Area area = new Area();
            TranslucentCellSelectionLayerUI.getSelectedArea(tbl).forEach(r -> area.add(new Area((Shape)r)));
            tbl.repaint(area.getBounds());
        }
    }
}

