/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.LookAndFeelUtils;
import example.TranslucentCellSelectionLayerUI;
import example.TranslucentCellSelectionTable;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new BorderLayout());
        JMenuBar mb = new JMenuBar();
        mb.add(LookAndFeelUtils.createLookAndFeelMenu());
        EventQueue.invokeLater(() -> this.getRootPane().setJMenuBar(mb));
        TranslucentCellSelectionTable table = new TranslucentCellSelectionTable(MainPanel.makeModel());
        JScrollPane scroll = new JScrollPane(table){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBackground(UIManager.getColor("Table.background"));
                this.getViewport().setOpaque(false);
                this.setViewportBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            }
        };
        this.add(new JLayer<JScrollPane>(scroll, new TranslucentCellSelectionLayerUI()));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private static TableModel makeModel() {
        Object[] columnNames = new String[]{"String", "Integer", "Boolean"};
        Object[][] data = new Object[][]{{"aaa", 12, true}, {"bbb", 5, false}, {"CCC", 92, true}, {"DDD", 0, false}, {"eee", 32, true}, {"fff", 8, false}, {"ggg", 64, true}, {"hhh", 1, false}};
        return new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST DashedBorderAnimationForSelectedCells");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

