/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CancelEditListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private final JTextArea log = new JTextArea();

    private MainPanel() {
        super(new BorderLayout());
        JButton button0 = new JButton("Default");
        button0.addActionListener(e -> this.openDefaultFileChooser());
        JPanel p0 = new JPanel();
        String t0 = "JFileChooser resizing may result in incorrect cell editor positioning";
        p0.setBorder(BorderFactory.createTitledBorder(t0));
        p0.add(button0);
        JButton button1 = new JButton("JFileChooser");
        button1.addActionListener(e -> this.openListViewFileChooser1());
        JButton button2 = new JButton("Dialog");
        button2.addActionListener(e -> this.openListViewFileChooser2());
        JPanel p1 = new JPanel();
        String t1 = "override ComponentListener#componentResized to cancel editing";
        p1.setBorder(BorderFactory.createTitledBorder(t1));
        p1.add(button1);
        p1.add(button2);
        JPanel p = new JPanel(new GridLayout(2, 1));
        p.add(p0);
        p.add(p1);
        this.add((Component)p, "North");
        this.add(new JScrollPane(this.log));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private void openDefaultFileChooser() {
        JFileChooser chooser = new JFileChooser();
        int retValue = chooser.showOpenDialog(this.log.getRootPane());
        if (retValue == 0) {
            this.log.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void openListViewFileChooser1() {
        JFileChooser chooser = new JFileChooser();
        chooser.addComponentListener(new CancelEditListener(chooser));
        int retValue = chooser.showOpenDialog(this.log.getRootPane());
        if (retValue == 0) {
            this.log.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void openListViewFileChooser2() {
        JFileChooser chooser = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) {
                JDialog dialog = super.createDialog(parent);
                dialog.addComponentListener(new CancelEditListener(this));
                return dialog;
            }
        };
        int retValue = chooser.showOpenDialog(this.log.getRootPane());
        if (retValue == 0) {
            this.log.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("@title@");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

