/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

class WeekHeaderList
extends JList<DayOfWeek> {
    public static final Dimension CELL_SIZE = new Dimension(36, 26);
    public static final Color BACKGROUND = new Color(0xDCDCDC);

    protected WeekHeaderList() {
        super(WeekHeaderList.makeDayOfWeekListModel());
    }

    @Override
    public void updateUI() {
        this.setCellRenderer(null);
        super.updateUI();
        ListCellRenderer r = this.getCellRenderer();
        this.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            Component c = r.getListCellRendererComponent(list, value, index, false, false);
            c.setBackground(BACKGROUND);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalAlignment(0);
                l.setText(value.getDisplayName(TextStyle.SHORT_STANDALONE, Locale.getDefault()));
            }
            return c;
        });
        this.getSelectionModel().setSelectionMode(1);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(0);
        this.setFixedCellWidth(WeekHeaderList.CELL_SIZE.width);
        this.setFixedCellHeight(WeekHeaderList.CELL_SIZE.height);
    }

    private static ListModel<DayOfWeek> makeDayOfWeekListModel() {
        DefaultListModel<DayOfWeek> weekModel = new DefaultListModel<DayOfWeek>();
        DayOfWeek firstDayOfWeek = WeekFields.of(Locale.getDefault()).getFirstDayOfWeek();
        for (int i = 0; i < DayOfWeek.values().length; ++i) {
            weekModel.add(i, firstDayOfWeek.plus(i));
        }
        return weekModel;
    }
}

