/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarViewListModel;
import example.WeekHeaderList;
import java.awt.Color;
import java.awt.Component;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class MonthList
extends JList<LocalDate> {
    public final LocalDate realLocalDate = LocalDate.now(ZoneId.systemDefault());
    private LocalDate currentLocalDate;

    protected MonthList() {
    }

    @Override
    public void updateUI() {
        this.setCellRenderer(null);
        super.updateUI();
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(6);
        this.setFixedCellWidth(WeekHeaderList.CELL_SIZE.width);
        this.setFixedCellHeight(WeekHeaderList.CELL_SIZE.height);
        this.setCellRenderer(new CalendarListRenderer());
        this.getSelectionModel().setSelectionMode(1);
    }

    public void setCurrentLocalDate(LocalDate date) {
        this.currentLocalDate = date;
        this.setModel(new CalendarViewListModel(date));
    }

    public LocalDate getCurrentLocalDate() {
        return this.currentLocalDate;
    }

    private final class CalendarListRenderer
    implements ListCellRenderer<LocalDate> {
        private final ListCellRenderer<? super LocalDate> renderer = new DefaultListCellRenderer();

        private CalendarListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LocalDate> list, LocalDate value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setOpaque(true);
                l.setHorizontalAlignment(0);
                l.setText(Integer.toString(value.getDayOfMonth()));
            }
            Color fgc = c.getForeground();
            if (YearMonth.from(value).equals(YearMonth.from(MonthList.this.getCurrentLocalDate()))) {
                DayOfWeek dow = value.getDayOfWeek();
                if (value.isEqual(MonthList.this.realLocalDate)) {
                    fgc = new Color(0x64FF64);
                } else if (dow == DayOfWeek.SUNDAY) {
                    fgc = new Color(0xFF6464);
                } else if (dow == DayOfWeek.SATURDAY) {
                    fgc = new Color(0x6464FF);
                }
            } else {
                fgc = Color.GRAY;
            }
            c.setForeground(isSelected ? c.getForeground() : fgc);
            return c;
        }
    }
}

