/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarUtils;
import example.MonthList;
import example.WeekHeaderList;
import example.WeekNumberList;
import example.WeekNumberListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private final JLabel yearMonthLabel = new JLabel("", 0);
    private final MonthList monthList = new MonthList();
    private final WeekNumberList weekNumberList = new WeekNumberList();

    private MainPanel() {
        this.installActions();
        JButton prev = new JButton("<");
        prev.addActionListener(e -> {
            LocalDate date = this.monthList.getCurrentLocalDate().minusMonths(1L);
            this.updateMonthView(date);
        });
        JButton next = new JButton(">");
        next.addActionListener(e -> {
            LocalDate date = this.monthList.getCurrentLocalDate().plusMonths(1L);
            this.updateMonthView(date);
        });
        JPanel yearMonthPanel = new JPanel(new BorderLayout());
        yearMonthPanel.add(this.yearMonthLabel);
        yearMonthPanel.add((Component)prev, "West");
        yearMonthPanel.add((Component)next, "East");
        Box box = Box.createVerticalBox();
        box.add(yearMonthPanel);
        box.add(Box.createVerticalStrut(2));
        this.updateMonthView(this.monthList.realLocalDate);
        JScrollPane scroll = new JScrollPane(this.monthList){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setColumnHeaderView(new WeekHeaderList());
                this.setVerticalScrollBarPolicy(21);
                this.setHorizontalScrollBarPolicy(31);
            }
        };
        scroll.setRowHeaderView(this.weekNumberList);
        box.add(scroll);
        this.add(box);
        this.setPreferredSize(new Dimension(320, 240));
    }

    private void installActions() {
        InputMap im = this.monthList.getInputMap(0);
        im.put(KeyStroke.getKeyStroke(39, 0), "selectNextIndex");
        im.put(KeyStroke.getKeyStroke(37, 0), "selectPreviousIndex");
        ActionMap am = this.monthList.getActionMap();
        am.put("selectPreviousIndex", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MainPanel.this.monthList.getLeadSelectionIndex();
                if (index > 0) {
                    MainPanel.this.monthList.setSelectedIndex(index - 1);
                } else {
                    LocalDate d = ((LocalDate)MainPanel.this.monthList.getModel().getElementAt(0)).minusDays(1L);
                    MainPanel.this.updateMonthView(MainPanel.this.monthList.getCurrentLocalDate().minusMonths(1L));
                    MainPanel.this.monthList.setSelectedValue(d, false);
                }
            }
        });
        am.put("selectNextIndex", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MainPanel.this.monthList.getLeadSelectionIndex();
                if (index < MainPanel.this.monthList.getModel().getSize() - 1) {
                    MainPanel.this.monthList.setSelectedIndex(index + 1);
                } else {
                    int lastDayOfMonth = MainPanel.this.monthList.getModel().getSize() - 1;
                    LocalDate d = ((LocalDate)MainPanel.this.monthList.getModel().getElementAt(lastDayOfMonth)).plusDays(1L);
                    MainPanel.this.updateMonthView(MainPanel.this.monthList.getCurrentLocalDate().plusMonths(1L));
                    MainPanel.this.monthList.setSelectedValue(d, false);
                }
            }
        });
        final Action selectPreviousRow = am.get("selectPreviousRow");
        am.put("selectPreviousRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int weekLength;
                int index = MainPanel.this.monthList.getLeadSelectionIndex();
                if (index < (weekLength = DayOfWeek.values().length)) {
                    LocalDate d = ((LocalDate)MainPanel.this.monthList.getModel().getElementAt(index)).minusDays(weekLength);
                    MainPanel.this.updateMonthView(MainPanel.this.monthList.getCurrentLocalDate().minusMonths(1L));
                    MainPanel.this.monthList.setSelectedValue(d, false);
                } else {
                    selectPreviousRow.actionPerformed(e);
                }
            }
        });
        final Action selectNextRow = am.get("selectNextRow");
        am.put("selectNextRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MainPanel.this.monthList.getLeadSelectionIndex();
                int weekLength = DayOfWeek.values().length;
                if (index > MainPanel.this.monthList.getModel().getSize() - weekLength) {
                    LocalDate d = ((LocalDate)MainPanel.this.monthList.getModel().getElementAt(index)).plusDays(weekLength);
                    MainPanel.this.updateMonthView(MainPanel.this.monthList.getCurrentLocalDate().plusMonths(1L));
                    MainPanel.this.monthList.setSelectedValue(d, false);
                } else {
                    selectNextRow.actionPerformed(e);
                }
            }
        });
    }

    public void updateMonthView(LocalDate localDate) {
        Locale locale = Locale.getDefault();
        DateTimeFormatter fmt = CalendarUtils.getLocalizedYearMonthFormatter(locale);
        String txt = localDate.format(fmt.withLocale(locale));
        this.yearMonthLabel.setText(CalendarUtils.getLocalizedYearMonthSeparator(txt));
        this.monthList.setCurrentLocalDate(localDate);
        this.weekNumberList.setModel(new WeekNumberListModel(localDate));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST CalendarWithWeekNumbers");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

