/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.WeekFields;
import java.util.Locale;
import javax.swing.AbstractListModel;

class CalendarViewListModel
extends AbstractListModel<LocalDate> {
    public static final int ROW_COUNT = 6;
    private final LocalDate startDate;

    protected CalendarViewListModel(LocalDate date) {
        LocalDate firstDayOfMonth = YearMonth.from(date).atDay(1);
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        int fdmDow = firstDayOfMonth.get(weekFields.dayOfWeek()) - 1;
        this.startDate = firstDayOfMonth.minusDays(fdmDow);
    }

    @Override
    public int getSize() {
        return DayOfWeek.values().length * 6;
    }

    @Override
    public LocalDate getElementAt(int index) {
        return this.startDate.plusDays(index);
    }
}

