/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CalendarUtils {
    private CalendarUtils() {
    }

    public static String getLocalizedPattern(Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.LONG, null, Chronology.ofLocale(locale), locale);
    }

    public static DateTimeFormatter getLocalizedYearMonthFormatter(Locale locale) {
        String localizedPattern = CalendarUtils.getLocalizedPattern(locale);
        String year = CalendarUtils.find(localizedPattern, Pattern.compile("(y+)"));
        String month = CalendarUtils.find(localizedPattern, Pattern.compile("(M+)"));
        String pattern = CalendarUtils.isYearFirst(locale) ? year + " " + month : month + " " + year;
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static String getLocalizedYearMonthSeparator(String str) {
        String[] list = str.split(" ");
        boolean isNumeric = Arrays.stream(list).flatMapToInt(CharSequence::chars).allMatch(Character::isDigit);
        String txt = isNumeric ? list[0] + " / " + list[1] : str;
        return txt;
    }

    public static String find(String str, Pattern ptn) {
        Matcher matcher = ptn.matcher(str);
        return matcher.find() ? matcher.group(1) : "";
    }

    public static boolean isYearFirst(Locale locale) {
        String localizedPattern = CalendarUtils.getLocalizedPattern(locale);
        int yearIndex = localizedPattern.indexOf(121);
        int monthIndex = localizedPattern.indexOf(77);
        return yearIndex != -1 && monthIndex != -1 && yearIndex < monthIndex;
    }
}

