/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarTable;
import example.CalendarUtils;
import example.CalendarViewTableModel;
import example.EventBarLayerUI;
import example.EventPeriod;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class MainPanel
extends JPanel {
    private MainPanel() {
        super(new BorderLayout());
        LocalDate date = LocalDate.now(ZoneId.systemDefault());
        CalendarTable calendarTable = new CalendarTable();
        calendarTable.setCurrentLocalDate(date);
        calendarTable.setModel(new CalendarViewTableModel(date));
        YearMonth currentMonth = YearMonth.from(date);
        List<EventPeriod> events = this.makeSampleEvents(currentMonth);
        JLayer<JTable> layer = new JLayer<JTable>(calendarTable, new EventBarLayerUI(events));
        JScrollPane scroll = new JScrollPane(layer){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setVerticalScrollBarPolicy(22);
                this.setHorizontalScrollBarPolicy(31);
            }
        };
        JScrollPane comp = new JScrollPane(this.makeLegendPanel(currentMonth, events));
        JSplitPane split = new JSplitPane(0, scroll, comp);
        split.setResizeWeight(0.8);
        this.add(split);
        this.setPreferredSize(new Dimension(320, 240));
    }

    private List<EventPeriod> makeSampleEvents(YearMonth ym) {
        ArrayList<EventPeriod> events = new ArrayList<EventPeriod>();
        events.add(new EventPeriod("Project Meeting", LocalDate.of(ym.getYear(), ym.getMonth(), 5), LocalDate.of(ym.getYear(), ym.getMonth(), 7), new Color(100, 150, 255, 180)));
        events.add(new EventPeriod("New Employee Training", LocalDate.of(ym.getYear(), ym.getMonth(), 6), LocalDate.of(ym.getYear(), ym.getMonth(), 12), new Color(255, 180, 100, 180)));
        events.add(new EventPeriod("Exhibition", LocalDate.of(ym.getYear(), ym.getMonth(), 20), LocalDate.of(ym.getYear(), ym.getMonth(), 21), new Color(150, 255, 150, 180)));
        events.add(new EventPeriod("Year-End Processing", LocalDate.of(ym.getYear(), ym.getMonth(), 18), LocalDate.of(ym.getYear(), ym.getMonth(), ym.lengthOfMonth()), new Color(255, 150, 200, 180)));
        events.add(new EventPeriod("System Maintenance", LocalDate.of(ym.getYear(), ym.getMonth(), 22), LocalDate.of(ym.getYear(), ym.getMonth(), 26), new Color(200, 150, 255, 180)));
        return events;
    }

    private JPanel makeLegendPanel(YearMonth currentMonth, List<EventPeriod> events) {
        Locale locale = Locale.getDefault();
        DateTimeFormatter fmt = CalendarUtils.getLocalizedYearMonthFormatter(locale);
        String txt = currentMonth.format(fmt.withLocale(locale));
        String title = CalendarUtils.getLocalizedYearMonthText(txt);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder(title));
        events.forEach(ev -> {
            JLabel label = new JLabel(String.format("%s (%d/%d-%d/%d)", ev.getName(), ev.getStartDate().getMonthValue(), ev.getStartDate().getDayOfMonth(), ev.getEndDate().getMonthValue(), ev.getEndDate().getDayOfMonth()));
            label.setOpaque(true);
            label.setBackground(ev.getColor());
            label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            panel.add(label);
        });
        return panel;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(MainPanel::createAndShowGui);
    }

    private static void createAndShowGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ignored) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getGlobal().severe(ex::getMessage);
            return;
        }
        JFrame frame = new JFrame("JST CalendarTableWithEventBars");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new MainPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

