/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.EventPeriod;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JTable;
import javax.swing.plaf.LayerUI;

class EventBarLayerUI
extends LayerUI<JTable> {
    private static final int BAR_HEIGHT = 10;
    private static final int BAR_MARGIN = 2;
    private final List<EventPeriod> events;

    protected EventBarLayerUI(List<EventPeriod> events) {
        this.events = events;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JTable table = (JTable)((JLayer)c).getView();
        this.assignTracksToEvents();
        for (EventPeriod ev : this.events) {
            this.drawEventBars(g2, table, ev);
        }
        g2.dispose();
    }

    private void assignTracksToEvents() {
        int[] tracks = new int[this.events.size()];
        boolean[] usedTracks = new boolean[this.events.size()];
        for (int i = 0; i < this.events.size(); ++i) {
            int track;
            EventPeriod event = this.events.get(i);
            Arrays.fill(usedTracks, false);
            for (int j = 0; j < i; ++j) {
                EventPeriod other = this.events.get(j);
                if (!this.isOverlapping(event, other)) continue;
                usedTracks[tracks[j]] = true;
            }
            for (track = 0; track < usedTracks.length && usedTracks[track]; ++track) {
            }
            tracks[i] = track;
            event.setTrack(track);
        }
    }

    private boolean isOverlapping(EventPeriod e1, EventPeriod e2) {
        boolean b1 = e1.getEndDate().isBefore(e2.getStartDate());
        boolean b2 = e2.getEndDate().isBefore(e1.getStartDate());
        return !b1 && !b2;
    }

    private void drawEventBars(Graphics2D g2, JTable table, EventPeriod event) {
        LocalDate calendarStartDate = (LocalDate)table.getModel().getValueAt(0, 0);
        int daysInTable = DayOfWeek.values().length * 6;
        LocalDate current = event.getStartDate();
        while (!current.isAfter(event.getEndDate())) {
            long sinceStart = ChronoUnit.DAYS.between(calendarStartDate, current);
            if (sinceStart >= 0L && sinceStart < (long)daysInTable) {
                int consecutiveDays = EventBarLayerUI.getConsecutiveDaysAndPaintBar(g2, table, event, current);
                current = current.plusDays(consecutiveDays);
                continue;
            }
            current = current.plusDays(1L);
        }
    }

    private static void drawEventBar(Graphics2D g2, EventPeriod event, Rectangle barRect) {
        boolean b;
        Color clr = event.getColor();
        g2.setColor(clr);
        g2.fillRoundRect(barRect.x, barRect.y, barRect.width, barRect.height, 5, 5);
        g2.setColor(clr.darker());
        g2.drawRoundRect(barRect.x, barRect.y, barRect.width, barRect.height, 5, 5);
        boolean bl = b = barRect.width > 60;
        if (b) {
            EventBarLayerUI.drawBarTitle(g2, event, barRect);
        }
    }

    private static int getConsecutiveDaysAndPaintBar(Graphics2D g2, JTable tbl, EventPeriod ev, LocalDate cur) {
        boolean notEndOfWeek;
        LocalDate calendarStartDate = (LocalDate)tbl.getModel().getValueAt(0, 0);
        long sinceStart = ChronoUnit.DAYS.between(calendarStartDate, cur);
        int trackOffset = ev.getTrack() * 12;
        int headerHeight = tbl.getTableHeader().getHeight();
        long daysInWeek = DayOfWeek.values().length;
        int weekRow = (int)(sinceStart / daysInWeek);
        int dayCol = (int)(sinceStart % daysInWeek);
        int consecutiveDays = 1;
        LocalDate nextDay = cur.plusDays(1L);
        boolean bl = notEndOfWeek = (long)dayCol != daysInWeek - 1L;
        while (!nextDay.isAfter(ev.getEndDate()) && notEndOfWeek) {
            nextDay = nextDay.plusDays(1L);
            if ((long)(dayCol + ++consecutiveDays) < daysInWeek) continue;
        }
        Rectangle firstRect = tbl.getCellRect(weekRow, dayCol, false);
        Rectangle lastRect = tbl.getCellRect(weekRow, dayCol + consecutiveDays - 1, false);
        int barX = firstRect.x + 5;
        int barY = firstRect.y + trackOffset + headerHeight;
        int barWidth = lastRect.x + lastRect.width - firstRect.x - 10;
        EventBarLayerUI.drawEventBar(g2, ev, new Rectangle(barX, barY, barWidth, 10));
        return consecutiveDays;
    }

    private static void drawBarTitle(Graphics2D g2, EventPeriod event, Rectangle rect) {
        g2.setColor(Color.BLACK);
        g2.setFont(g2.getFont().deriveFont(9.0f));
        FontMetrics fm = g2.getFontMetrics();
        String eventName = event.getName();
        int textWidth = fm.stringWidth(eventName);
        if (textWidth > rect.width - 6) {
            eventName = eventName.substring(0, Math.min(eventName.length(), 5)) + "...";
        }
        int textX = rect.x + 3;
        int textY = rect.y + rect.height / 2 + fm.getAscent() / 2 - 1;
        g2.drawString(eventName, textX, textY);
    }
}

