/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.Locale;
import javax.swing.table.DefaultTableModel;

class CalendarViewTableModel
extends DefaultTableModel {
    public static final int WEEKS = 6;
    private final LocalDate startDate;
    private final WeekFields weekFields = WeekFields.of(Locale.getDefault());

    protected CalendarViewTableModel(LocalDate date) {
        LocalDate firstDayOfMonth = YearMonth.from(date).atDay(1);
        int v = firstDayOfMonth.get(this.weekFields.dayOfWeek()) - 1;
        this.startDate = firstDayOfMonth.minusDays(v);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return LocalDate.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.weekFields.getFirstDayOfWeek().plus(column).getDisplayName(TextStyle.SHORT_STANDALONE, Locale.getDefault());
    }

    @Override
    public int getRowCount() {
        return 6;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.startDate.plusDays((long)row * (long)this.getColumnCount() + (long)column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

