/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarTable;
import java.awt.Color;
import java.awt.Component;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class CalendarCellRenderer
extends DefaultTableCellRenderer {
    CalendarCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, false, false, row, column);
        if (c instanceof JLabel && table instanceof CalendarTable && value instanceof LocalDate) {
            JLabel dayLabel = (JLabel)c;
            dayLabel.setHorizontalAlignment(0);
            dayLabel.setVerticalAlignment(1);
            CalendarTable calendarTable = (CalendarTable)table;
            LocalDate date = (LocalDate)value;
            boolean isToday = date.equals(LocalDate.now(ZoneId.systemDefault()));
            int day = date.getDayOfMonth();
            String txt = isToday ? this.getCircledNumber(day) : Integer.toString(day);
            dayLabel.setText(txt);
            LocalDate currentDate = calendarTable.getCurrentLocalDate();
            dayLabel.setForeground(this.getDayOfWeekColor(date, currentDate, isToday));
        }
        return c;
    }

    private Color getDayOfWeekColor(LocalDate date, LocalDate currentDate, boolean isToday) {
        Color color;
        boolean isCurrentMonth;
        boolean bl = isCurrentMonth = date.getMonth() == currentDate.getMonth();
        if (isCurrentMonth) {
            DayOfWeek dow = date.getDayOfWeek();
            color = isToday ? new Color(255, 100, 0) : (dow == DayOfWeek.SUNDAY ? new Color(255, 100, 100) : (dow == DayOfWeek.SATURDAY ? new Color(100, 100, 255) : Color.BLACK));
        } else {
            color = Color.LIGHT_GRAY;
        }
        return color;
    }

    private String getCircledNumber(int number) {
        String txt = number >= 1 && number <= 20 ? String.valueOf((char)(9312 + number - 1)) : (number >= 21 && number <= 31 ? String.valueOf((char)(12881 + number - 21)) : String.valueOf(number));
        return txt;
    }
}

