/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Component;
import java.time.DayOfWeek;
import java.time.temporal.WeekFields;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;

class WeekHeaderRenderer
extends DefaultTableCellRenderer {
    public static final Color SUNDAY_BGC = new Color(11538970);
    public static final Color SATURDAY_BGC = new Color(1708720);
    private final WeekFields weekFields = WeekFields.of(Locale.getDefault());

    WeekHeaderRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        DayOfWeek week = this.weekFields.getFirstDayOfWeek().plus(column);
        if (week == DayOfWeek.SUNDAY) {
            c.setForeground(table.getSelectionForeground());
            c.setBackground(SUNDAY_BGC);
        } else if (week == DayOfWeek.SATURDAY) {
            c.setForeground(table.getSelectionForeground());
            c.setBackground(SATURDAY_BGC);
        } else {
            c.setForeground(table.getForeground());
            c.setBackground(table.getTableHeader().getBackground());
        }
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            l.setHorizontalAlignment(0);
            Color gridColor = UIManager.getColor("Table.gridColor");
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 1, gridColor);
            CompoundBorder b = BorderFactory.createCompoundBorder(border, l.getBorder());
            l.setBorder(b);
        }
        return c;
    }
}

