/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.CalendarTableRenderer;
import example.WeekHeaderRenderer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.time.LocalDate;
import java.util.Optional;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class MonthTable
extends JTable {
    private LocalDate currentLocalDate;

    MonthTable() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setDefaultRenderer(LocalDate.class, new CalendarTableRenderer());
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setFillsViewportHeight(true);
        JTableHeader header = this.getTableHeader();
        header.setResizingAllowed(false);
        header.setReorderingAllowed(false);
        this.updateWeekHeaderRenderer();
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        EventQueue.invokeLater(this::updateWeekHeaderRenderer);
    }

    public void setCurrentLocalDate(LocalDate date) {
        this.currentLocalDate = date;
    }

    public LocalDate getCurrentLocalDate() {
        return this.currentLocalDate;
    }

    private void updateWeekHeaderRenderer() {
        TableColumnModel cm = this.getColumnModel();
        WeekHeaderRenderer r = new WeekHeaderRenderer();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setHeaderRenderer(r);
        }
        this.getTableHeader().repaint();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                JTable tbl = this.getTable();
                Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, tbl);
                if (c instanceof JScrollPane) {
                    int rowCount = tbl.getModel().getRowCount() + 1;
                    Rectangle r = SwingUtilities.calculateInnerArea((JScrollPane)c, null);
                    d.height = Math.max(r.height / rowCount, 24);
                }
                return d;
            }
        };
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Class<JViewport> clz = JViewport.class;
        Optional.ofNullable(SwingUtilities.getAncestorOfClass(clz, this)).filter(clz::isInstance).map(clz::cast).ifPresent(this::updateRowsHeight);
    }

    private void updateRowsHeight(JViewport viewport) {
        int height = viewport.getExtentSize().height;
        int rowCount = this.getModel().getRowCount();
        int defaultRowHeight = height / rowCount;
        int remainder = height % rowCount;
        for (int i = 0; i < rowCount; ++i) {
            int a = defaultRowHeight + Math.min(1, Math.max(0, remainder--));
            this.setRowHeight(i, Math.max(1, a));
        }
    }
}

